***************************************************************************
* REALTIME 3D RASTERS BY THE POWERMAN OF TWB				  *
* (C) THE WILD BOYS, 1992						  *
*									  *
* Yeah man, Powerman presents yet another nice source for you, this one   *
* is from the intro to Waveforms, although I precalculated the rasters    *
* on that intro, these ones are done in realtime which means you can get  *
* some nice effects by changing the values added to XROT,YROT and ZROT in *
* the routine MAIN.  If you use this code credit me, unless you are       *
* Argonut in which case say you ripped this code.........		  *
* check y'all later......			  			  *
*									  *
* Message to Tony B - where the hell are you?????		          *
***************************************************************************

		JMP BEGIN

SCREEN1		EQU $280000-(2*(160*200))
SCREEN2		EQU $280000-(1*(160*200))
NUM_BARS	EQU 10
SPACING		EQU 4
BAR_HEIGHT	EQU 26

MAX_POINTS	EQU NUM_BARS		
DIST		EQU 256
XCENTRE		EQU 160
YCENTRE		EQU 100

VBL2		CLR.B $FFFFFA1B.W
		MOVE.B #1,$FFFFFA21.W
		MOVE.B #8,$FFFFFA1B.W
		MOVE.L #TB1,$120.W
		MOVE.W RASTERS+(2*200),$FFFF8240.W
		MOVE.L #RASTERS+(2*200)+2,TB1+2
		ST VBLFLAG
		RTE

TB1		MOVE.W 0,$FFFF8240.W
		ADDQ.L #2,TB1+2
		RTE		

MAKE_RASTERS	LEA RASTERS+(2*(200*3)),A0
		CLR.L D0
		MOVE.L D0,D1
		MOVE.L D0,D2
		MOVE.L D0,D3
		MOVE.L D0,D4
		MOVE.L D0,D5
		MOVE.L D0,D6
		MOVE.L D0,D7
		MOVE.L D0,A1
		MOVE.L D0,A2
		MOVE.L D0,A3
		MOVE.L D0,A4
		MOVE.L D0,A5
		MOVE.L D0,A6
		REPT 21
		MOVEM.L D0-D7/A1-A6,-(A0)		56
		ENDR
		MOVEM.L D0-D5,-(A0)

		BSR.S .L3
		CLR.W RASTERS+(2*200)
		CLR.W RASTERS+(2*200)+(2*200)
		RTS

.L3		LEA RASTERS+(2*200),A0
		LEA SCREEN,A1
		LEA Z_COORDS,A2
		MOVE.W #NUM_BARS-1,D0
		MOVE.W (A2),D1
		CMP.W ((NUM_BARS-1)*4)(A2),D1
		BGE.S .L1
		LEA NUM_BARS*4(A1),A1

.L2		MOVE.L -(A1),D1
		ADD.W D1,D1
		LEA (A0,D1.W),A2
		LEA BAR,A3
		REPT BAR_HEIGHT
		MOVE.W (A3)+,(A2)+
		ENDR
		DBF D0,.L2
		RTS

;first bar closer
.L1		MOVE.L (A1)+,D1
		ADD.W D1,D1
		LEA (A0,D1.W),A2
		LEA BAR,A3
		REPT BAR_HEIGHT
		MOVE.W (A3)+,(A2)+
		ENDR
		DBF D0,.L1
		RTS

RASTERS		DCB.W 200*3,0

BAR_WORLD	
YOFF		SET (BAR_HEIGHT+SPACING)*(NUM_BARS/2)
		REPT NUM_BARS
		DC.W 0,YOFF,0
YOFF		SET YOFF-(BAR_HEIGHT+SPACING)
		ENDR

ROTATE_POINTS	LEA SINTAB,A0
		LEA 128*2(A0),A2
		LEA SINCOS,A1

		MOVEM.W XROT,D0-D2
		MOVE.W #511,D3
		AND.W D3,D0
		AND.W D3,D1
		AND.W D3,D2
		MOVEM.W D0-D2,XROT

		ADD.W D0,D0	
		ADD.W D1,D1
		ADD.W D2,D2
		MOVE.W (A0,D0.W),(A1)+	Sin x (offset 0)
		MOVE.W (A2,D0.W),(A1)+	Cos x (offset 2)
		MOVE.W (A0,D1.W),(A1)+	Sin y (offset 4)
		MOVE.W (A2,D1.W),(A1)+	Cos y (offset 6)
		MOVE.W (A0,D2.W),(A1)+	Sin z (offset 8)
		MOVE.W (A2,D2.W),(A1)	Cos z (offset 10)
		LEA -10(A1),A1

		MOVE.W 4(A1),D0
		MOVE.W D0,D1
		MULS 8(A1),D0
		ADD.L D0,D0
		SWAP D0

		NEG.W D1
		MULS 10(A1),D1
		ADD.L D1,D1
		SWAP D1
;MATRIX(1,1)
		MOVE.W 10(A1),D2
		MOVE.W D2,D6
		MULS 6(A1),D2
		ADD.L D2,D2
		SWAP D2
		MOVE.W D2,CALC_X_COORD+2
;MATRIX(1,2)
		MOVE.W (A1),D2
		MULS D1,D2
		MOVE.W 8(A1),D3
		MOVE.W D3,D4
		MOVE.W D4,D5
		MULS 2(A1),D3
		SUB.L D2,D3
		ADD.L D3,D3
		SWAP D3
		MOVE.W D3,CALC_X_COORD+6
;MATRIX(1,3)
		MOVE.W 2(A1),D2
		MULS D1,D2
		MULS (A1),D4
		ADD.L D2,D4
		ADD.L D4,D4
		SWAP D4
		MOVE.W D4,CALC_X_COORD+10
;MATRIX(2,1)
		NEG.W D5
		MULS 6(A1),D5
		ADD.L D5,D5
		SWAP D5
		MOVE.W D5,CALC_Y_COORD+2
;MATRIX(2,2)
		MOVE.W D6,D5
		MULS 2(A1),D6
		MOVE.W (A1),D3
		MULS D0,D3
		SUB.L D3,D6
		ADD.L D6,D6
		SWAP D6
		MOVE.W D6,CALC_Y_COORD+6
;MATRIX(2,3)
		MULS (A1),D5
		MOVE.W 2(A1),D3
		MOVE.W D3,D6
		MULS D0,D3
		ADD.L D3,D5
		ADD.L D5,D5
		SWAP D5
		MOVE.W D5,CALC_Y_COORD+10
;MATRIX(3,1)
		MOVE.W 4(A1),CALC_Z_COORD+2
;MATRIX(3,2)
		MOVE.W 6(A1),D2
		MOVE.W D2,D4
		NEG.W D2
		MULS (A1),D2
		ADD.L D2,D2
		SWAP D2
		MOVE.W D2,CALC_Z_COORD+6
;MATRIX(3,3)
		MULS D6,D4
		ADD.L D4,D4
		SWAP D4
		MOVE.W D4,CALC_Z_COORD+10

		MOVE.W NUM_POINTS,D6
		SUBQ.W #1,D6
		BGE.S .L1
		RTS
.L1		MOVE.L WORLD,A0
		LEA SCREEN,A1
		LEA Z_COORDS,A2
		MOVE.W #DIST,A3
		MOVEM.W XOFFSET,D7/A4/A5

DO_ROTATION	MOVEM.W (A0)+,D0-D2

		ADD.W D7,D0		\
		ADD.W A4,D1		| add x,y,z offsets
		ADD.W A5,D2		/
		MOVEM.W D0-D2,-(A7)

		MOVE.W D0,D3
		MOVE.W D1,D4
		MOVE.W D2,D5
CALC_X_COORD	MULS #0,D0
		MULS #0,D1
		MULS #0,D2
		ADDX.L D0,D1
		ADDX.L D2,D1
		ADD.L D1,D1
		SWAP D1			d1=x

CALC_Y_COORD	MULS #0,D3
		MULS #0,D4
		MULS #0,D5
		ADDX.L D3,D4
		ADDX.L D5,D4
		ADD.L D4,D4
		SWAP D4			d4=y

		MOVEM.W (A7)+,D0/D2/D3
CALC_Z_COORD	MULS #0,D0
		MULS #0,D2
		MULS #0,D3
		ADDX.L D0,D2
		ADDX.L D3,D2
		ADD.L D2,D2
		MOVE.L D2,(A2)+

		SWAP D2
		EXT.L D2
		EXT.L D1
		EXT.L D4
		ASL.L #8,D1
		ASL.L #8,D4
		ADD.L A3,D2
		DIVS D2,D1
		DIVS D2,D4
		NEG.W D4
		ADD.W #XCENTRE,D1
		ADD.W #YCENTRE,D4
		MOVE.W D1,(A1)+	
		MOVE.W D4,(A1)+
		
		DBF D6,DO_ROTATION
		RTS

SINTAB		DC.W 0,402,804,1206,1608,2009,2411,2811
		DC.W 3212,3612,4011,4410,4808,5205,5602,5998
		DC.W 6393,6787,7180,7571,7962,8351,8740,9127
		DC.W 9512,9896,10279,10660,11039,11417,11793,12167
		DC.W 12540,12910,13279,13646,14010,14373,14733,15091
		DC.W 15447,15800,16151,16500,16846,17190,17531,17869
 		DC.W 18205,18538,18868,19195,19520,19841,20160,20475
 		DC.W 20788,21097,21403,21706,22006,22302,22595,22884
 		DC.W 23170,23453,23732,24008,24279,24548,24812,25073
 		DC.W 25330,25583,25833,26078,26320,26557,26791,27020
 		DC.W 27246,27467,27684,27897,28106,28311,28511,28707
 		DC.W 28899,29086,29269,29448,29622,29792,29957,30118
 		DC.W 30274,30425,30572,30715,30853,30986,31114,31238
 		DC.W 31357,31471,31581,31686,31786,31881,31972,32058
 		DC.W 32138,32214,32286,32352,32413,32470,32522,32568
 		DC.W 32610,32647,32679,32706,32729,32746,32758,32766
	
 		DC.W 32767,32766,32758,32746,32729,32706,32679,32647
 		DC.W 32610,32568,32522,32470,32413,32352,32286,32214
 		DC.W 32138,32058,31972,31881,31786,31686,31581,31471
 		DC.W 31357,31238,31114,30986,30853,30715,30572,30425
 		DC.W 30274,30118,29957,29792,29622,29448,29269,29086
 		DC.W 28899,28707,28511,28311,28106,27897,27684,27467
 		DC.W 27246,27020,26791,26557,26320,26078,25833,25583
 		DC.W 25330,25073,24812,24548,24279,24008,23732,23453
 		DC.W 23170,22884,22595,22302,22006,21706,21403,21097
 		DC.W 20788,20475,20160,19841,19520,19195,18868,18538
 		DC.W 18205,17869,17531,17190,16846,16500,16151,15800
 		DC.W 15447,15091,14733,14373,14010,13646,13279,12910
 		DC.W 12540,12167,11793,11417,11039,10660,10279,9896
 		DC.W 9512,9127,8740,8351,7962,7571,7180,6787
 		DC.W 6393,5998,5602,5205,4808,4410,4011,3612
 		DC.W 3212,2811,2411,2009,1608,1206,804,402
 	
		DC.W 0,-402,-804,-1206,-1608,-2009,-2411,-2811
 		DC.W -3212,-3612,-4011,-4410,-4808,-5205,-5602,-5998
 		DC.W -6393,-6787,-7180,-7571,-7962,-8351,-8740,-9127
 		DC.W -9512,-9896,-10279,-10660,-11039,-11417,-11793,-12167
 		DC.W -12540,-12910,-13279,-13646,-14010,-14373,-14733,-15091
 		DC.W -15447,-15800,-16151,-16500,-16846,-17190,-17531,-17869
 		DC.W -18205,-18538,-18868,-19195,-19520,-19841,-20160,-20475
 		DC.W -20788,-21097,-21403,-21706,-22006,-22302,-22595,-22884
 		DC.W -23170,-23453,-23732,-24008,-24279,-24548,-24812,-25073
 		DC.W -25330,-25583,-25833,-26078,-26320,-26557,-26791,-27020
 		DC.W -27246,-27467,-27684,-27897,-28106,-28311,-28511,-28707
 		DC.W -28899,-29086,-29269,-29448,-29622,-29792,-29957,-30118
 		DC.W -30274,-30425,-30572,-30715,-30853,-30986,-31114,-31238
 		DC.W -31357,-31471,-31581,-31686,-31786,-31881,-31972,-32058
 		DC.W -32138,-32214,-32286,-32352,-32413,-32470,-32522,-32568
 		DC.W -32610,-32647,-32679,-32706,-32729,-32746,-32758,-32766
	
 		DC.W -32767,-32766,-32758,-32746,-32729,-32706,-32679,-32647
 		DC.W -32610,-32568,-32522,-32470,-32413,-32352,-32286,-32214
 		DC.W -32138,-32058,-31972,-31881,-31786,-31686,-31581,-31471
 		DC.W -31357,-31238,-31114,-30986,-30853,-30715,-30572,-30425
 		DC.W -30274,-30118,-29957,-29792,-29622,-29448,-29269,-29086
 		DC.W -28899,-28707,-28511,-28311,-28106,-27897,-27684,-27467
 		DC.W -27246,-27020,-26791,-26557,-26320,-26078,-25833,-25583
 		DC.W -25330,-25073,-24812,-24548,-24279,-24008,-23732,-23453
 		DC.W -23170,-22884,-22595,-22302,-22006,-21706,-21403,-21097
 		DC.W -20788,-20475,-20160,-19841,-19520,-19195,-18868,-18538
 		DC.W -18205,-17869,-17531,-17190,-16846,-16500,-16151,-15800
 		DC.W -15447,-15091,-14733,-14373,-14010,-13646,-13279,-12910
 		DC.W -12540,-12167,-11793,-11417,-11039,-10660,-10279,-9896
 		DC.W -9512,-9127,-8740,-8351,-7962,-7571,-7180,-6787
 		DC.W -6393,-5998,-5602,-5205,-4808,-4410,-4011,-3612
 		DC.W -3212,-2811,-2411,-2009,-1608,-1206,-804,-402
	
;Duplicate first 128 entries for cosine overlap

 		DC.W 0,402,804,1206,1608,2009,2411,2811
 		DC.W 3212,3612,4011,4410,4808,5205,5602,5998
 		DC.W 6393,6787,7180,7571,7962,8351,8740,9127
 		DC.W 9512,9896,10279,10660,11039,11417,11793,12167
 		DC.W 12540,12910,13279,13646,14010,14373,14733,15091
 		DC.W 15447,15800,16151,16500,16846,17190,17531,17869
 		DC.W 18205,18538,18868,19195,19520,19841,20160,20475
 		DC.W 20788,21097,21403,21706,22006,22302,22595,22884
 		DC.W 23170,23453,23732,24008,24279,24548,24812,25073
 		DC.W 25330,25583,25833,26078,26320,26557,26791,27020
 		DC.W 27246,27467,27684,27897,28106,28311,28511,28707
 		DC.W 28899,29086,29269,29448,29622,29792,29957,30118
 		DC.W 30274,30425,30572,30715,30853,30986,31114,31238
 		DC.W 31357,31471,31581,31686,31786,31881,31972,32058
 		DC.W 32138,32214,32286,32352,32413,32470,32522,32568
 		DC.W 32610,32647,32679,32706,32729,32746,32758,32766

BEGIN		MOVE.L A7,STACK
		LEA MY,A7

		CLR.L -(A7)
		MOVE.W #32,-(A7)
		TRAP #1		
		ADDQ.L #6,A7
		
		MOVE.L #SCREEN1,SCR1
		MOVE.L #SCREEN2,SCR2
		JSR INIT
		JSR SET_UP
		JSR MAIN
		JSR END

		MOVE.L STACK,-(A7)
		MOVE.W #32,-(A7)
		TRAP #1		
		ADDQ.L #6,A7

		CLR.L -(A7)
		TRAP #1

MAIN		JSR ROTATE_POINTS
		JSR MAKE_RASTERS
		ADD.W #1,XROT
		ADD.W #2,YROT
		ADD.W #3,ZROT
		JSR SWAP
		CMPI.B #57,$FFFFFC02.W
		BNE MAIN
		RTS

SET_UP		MOVE.L #SCREEN1,PHYSIC
		MOVE.L #SCREEN2,LOGIC
		MOVE.L #BAR_WORLD,WORLD
		MOVE.W #NUM_BARS,NUM_POINTS
		MOVE.L #VBL2,$70.W
		BCLR #3,$FFFFFA17.W
		MOVE.W #$2300,SR
		RTS

WAITVBL		CLR.B VBLFLAG
.L1		TST.B VBLFLAG
		BEQ .L1
		RTS

LOGIC		DS.L 1
PHYSIC		DS.L 1

SWAP		MOVEM.L LOGIC,D0-D1
		MOVE.L D0,D2
		LSR.W #8,D2
		MOVE.L D2,$FFFF8200.W
		BSR WAITVBL
		EXG D0,D1
		MOVEM.L D0-D1,LOGIC
		RTS

INIT		MOVE.W #$2700,SR
		DC.W $A000		
		DC.W $A00A		
		MOVE.B #$12,D0		
		BSR IKBD		
		LEA $FFFF8240.W,A0
		MOVEQ.W #8-1,D0
.COLS		MOVE.L #0,(A0)+
		DBF D0,.COLS
		MOVEQ.L #0,D1
		MOVE.L SCR1,A0
		CMP.L SCR2,A0
		BEQ .L222
		MOVE.L SCR2,A1
		MOVE.L A1,A2
.L33		CMPA.L A0,A2
		BEQ .L2
		MOVE.L D1,(A0)+
		MOVE.L D1,(A1)+
		BRA .L33		
.L222		MOVE.W #32000/4-1,D0
.L22		MOVE.L D1,(A0)+
		DBF D0,.L22
.L2		LEA VARS,A0
		MOVE.L $70.W,(A0)+
		MOVE.L $120.W,(A0)+
		MOVE.L $118.W,(A0)+
		MOVE.L $134.W,(A0)+
		MOVE.L $68.W,(A0)+
		MOVE.B $FFFFFA07.W,(A0)+
		MOVE.B $FFFFFA09.W,(A0)+
		MOVE.B $FFFFFA13.W,(A0)+
		MOVE.B $FFFFFA1B.W,(A0)+
		MOVE.B $FFFFFA21.W,(A0)+
		MOVE.B $FFFFFA15.W,(A0)+
		MOVE.B $FFFFFA19.W,(A0)+
		MOVE.B $FFFFFA1F.W,(A0)+
		MOVE.B $FFFFFA15.W,(A0)+
		MOVE.L #VBL,$70.W		
		MOVE.L #RTE,$68.W
		MOVE.L #RTE,$134.W
		MOVE.L #KEY,$118.W
		MOVE.L SCR1,D0
		LSR.W #8,D0
		MOVE.W #$2300,SR
		CLR.B VBLFLAG
.WAITVBL	TST.B VBLFLAG
		BEQ .WAITVBL
		MOVE.L D0,$FFFF8200.W
		CLR.B $FFFF8260.W
		MOVE.B #2,$FFFF820A.W
		MOVE.W #$2700,SR
		CLR.B $FFFFFA07.W
		CLR.B $FFFFFA09.W
		CLR.B $FFFFFA13.W
		CLR.B $FFFFFA15.W
		ORI.B #1,$FFFFFA07.W		TIMER B ENABLE
		ORI.B #1,$FFFFFA13.W
		ORI.B #64,$FFFFFA09.W		KEYBOARD ENABLE
		ORI.B #64,$FFFFFA15.W
		RTS
SCR1		DS.L 1
SCR2		DS.L 1
VARS		DS.B 32
VBL		ST VBLFLAG
RTE		RTE
VBLFLAG		DC.W 0
KEY		MOVE.B $FFFFFC02.W,PRESS
		BCLR #6,$FFFFFA11.W
		RTE
PRESS		DC.W 0	
WAITKEY		MOVE.W #$2300,SR
		CLR.B PRESS
.L1		CMPI.B #57+128,PRESS
		BNE .L1
		RTS
END		MOVE.W #$2700,SR
		LEA $FFFF8800.W,A0
		MOVE.L #$700FF00,(A0)
		MOVE.L #$8000000,(A0)
		MOVE.L #$9000000,(A0)
		MOVE.L #$A000000,(A0)
		LEA VARS,A0
		MOVE.L (A0)+,$70.W
		MOVE.L (A0)+,$120.W
		MOVE.L (A0)+,$118.W
		MOVE.L (A0)+,$134.W
		MOVE.L (A0)+,$68.W
		MOVE.B (A0)+,$FFFFFA07.W
		MOVE.B (A0)+,$FFFFFA09.W
		MOVE.B (A0)+,$FFFFFA13.W
		MOVE.B (A0)+,$FFFFFA1B.W
		MOVE.B (A0)+,$FFFFFA21.W
		MOVE.B (A0)+,$FFFFFA15.W
		MOVE.B (A0)+,$FFFFFA19.W
		MOVE.B (A0)+,$FFFFFA1F.W
		MOVE.B (A0)+,$FFFFFA15.W
		MOVE.W #$777,$FFFF8240.W
		MOVE.W #0,$FFFF8242.W
		MOVE.W #0,$FFFF8246.W
		DC.W $A000
		DC.W $A009
		MOVE.B #8,D0
		BSR IKBD
		MOVE.W #1,-(A7)
		PEA $78000+$80000
		PEA $78000+$80000
		MOVE.W #5,-(A7)
		TRAP #14
		LEA 12(A7),A7
		MOVE.W #$2300,SR
		RTS

STACK		DS.L 1

IKBD		LEA $FFFFFC00.W,A0
.L1		MOVE.B (A0),D1
		BTST #1,D1
		BEQ .L1
		MOVE.B D0,2(A0)
		RTS

		DS.L 400
MY		DS.L 1

WORLD		DS.L 1			address of object coords
SCREEN		DS.W MAX_POINTS*2	after perspect,coords stored here
Z_COORDS	DS.L MAX_POINTS
NUM_POINTS	DS.W 1			no. points in current object
SINCOS		DS.W 6

XROT		DC.W 0
YROT		DC.W 0
ZROT		DC.W 0
XOFFSET		DC.W 0
YOFFSET		DC.W 0
ZOFFSET		DC.W 60

BAR		DC.W $100,$200,$200,$300,$300,$400,$400,$500,$500
		DC.W $600,$600,$700,$700,$700,$700,$600,$600
		DC.W $500,$500,$400,$400,$300,$300,$200,$200,$100
										